//
//  CRPhotoViewController.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 04/04/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRPhotoViewControllerBase.h"

@class CRInplaceEditorController;
@class CRBackgroundSelector;
@class CRPhotoScrollView;
@class CRPhotoView;
@class CRSlider;

///////////////////////////////////////////////////////////////////////////////////////////////////
// CRPhotoViewController
///////////////////////////////////////////////////////////////////////////////////////////////////
@interface CRPhotoViewController : CRPhotoViewControllerBase<CRPhotoViewImageSourceProtocol>
{	
	// Defaults
	NSString*	selectedProviderStore;	// background provider NSUSerDefaults location
	
	// Zoom
	BOOL		callFromSlider;			// aux flag
	BOOL		wantsZoomUpdate;		// aux flag
}

@property (nonatomic, copy)		NSString*						selectedProviderStore;	// background provider NSUserDefaults store

// Outlets
@property (nonatomic, assign) IBOutlet NSView*					zoomControlView;
@property (nonatomic, assign) IBOutlet NSView*					backgroundSelectorView;
@property (nonatomic, assign) IBOutlet CRSlider*				zoomControl;
@property (nonatomic, assign) IBOutlet CRBackgroundSelector*	backgroundSelector;
@property (nonatomic, assign) IBOutlet CRPhotoScrollView*		scrollView;
@property (nonatomic, readonly) CRPhotoView*					photoViewer;			// a wrapper around the [self view] method

- (void)saveDefaultsOptions;

@end